"use strict";
var chart;
var graph;
var chartData = JSON.parse(JSON.stringify(report_data.user_chart_string));
jQuery(document).ready(function () {
	// SERIAL CHART
	chart = new AmCharts.AmSerialChart();
	chart.pathToImages = report_data.pathToImages;
	chart.dataProvider = chartData;
	chart.marginLeft = 10;
	chart.categoryField = "udate";
	chart.dataDateFormat = "YYYY-MM-DD";
	// listen for "dataUpdated" event (fired when chart is inited) and call zoomChart method when it happens
	chart.addListener("dataUpdated", zoomChart);
	// AXES
	// category
	var categoryAxis = chart.categoryAxis;
	categoryAxis.parseDates = true; // as our data is date-based, we set parseDates to true
	categoryAxis.minPeriod = "DD"; // our data is yearly, so we set minPeriod to YYYY
	categoryAxis.dashLength = 3;
	categoryAxis.minorGridEnabled = true;
	categoryAxis.minorGridAlpha = 0.1;
	// value
	var valueAxis = new AmCharts.ValueAxis();
	valueAxis.axisAlpha = 0;
	valueAxis.inside = true;
	valueAxis.dashLength = 3;
	chart.addValueAxis(valueAxis);
	// GRAPH
	graph = new AmCharts.AmGraph();
	graph.type = "smoothedLine"; // this line makes the graph smoothed line.
	graph.lineColor = "#d1655d";
	graph.negativeLineColor = "#637bb6"; // this line makes the graph to change color when it drops below 0
	graph.bullet = "round";
	graph.bulletSize = 8;
	graph.bulletBorderColor = "#FFFFFF";
	graph.bulletBorderAlpha = 1;
	graph.bulletBorderThickness = 2;
	graph.lineThickness = 2;
	graph.valueField = "value";
	chart.addGraph(graph);
	// CURSOR
	var chartCursor = new AmCharts.ChartCursor();
	chartCursor.cursorAlpha = 0;
	chartCursor.cursorPosition = "mouse";
	chartCursor.categoryBalloonDateFormat =  "DD";
	chart.addChartCursor(chartCursor);
	// SCROLLBAR
	var chartScrollbar = new AmCharts.ChartScrollbar();
	chart.addChartScrollbar(chartScrollbar);
	chart.creditsPosition = "bottom-right";
	// WRITE
	chart.write("chart-line");
});
// this method is called when chart is first inited as we listen for "dataUpdated" event
function zoomChart() {
	// different zoom methods can be used - zoomToIndexes, zoomToDates, zoomToCategoryValues
}
var chart="";
var legend='';
var chartDataCount = JSON.parse(JSON.stringify(report_data.package_count_json));
jQuery(document).ready(function () {
	// PIE CHART
	chart = new AmCharts.AmPieChart();
	chart.dataProvider = chartDataCount;
	chart.addTitle("Package's Users ", 16);
	chart.titleField = "Package";
	chart.valueField = "value";
	chart.sequencedAnimation = true;
	chart.outlineColor = "";
	chart.colors	=["#87D37C", "#F89406", "#22A7F0",  "#F9BF3B", "#B0DE09",  "#0D8ECF", "#0D52D1", "#2A0CD0", "#8A0CCF", "#CD0D74", "#754DEB", "#DDDDDD", "#999999", "#333333", "#000000", "#57032A", "#CA9726", "#990000", "#4B0C25"];
	chart.outlineAlpha = 0.8;
	chart.outlineThickness = 2;
	chart.labelRadius = 15;
	// this makes the chart 3D
	chart.depth3D = 20;
	chart.angle = 30;
	// WRITE
	chart.write("package_user");
});
var chart="";
var legend='';
var chartDataAmount = JSON.parse(JSON.stringify(report_data.package_amount_json));
jQuery(document).ready(function () {
	// PIE CHART
	chart = new AmCharts.AmPieChart();
	chart.addTitle("Earn By Packages ", 16);
	chart.dataProvider = chartDataAmount;
	chart.titleField = "Package";
	chart.valueField = "value";
	chart.colors	=["#87D37C", "#F89406", "#22A7F0",  "#B0DE09",  "#0D8ECF", "#0D52D1", "#2A0CD0", "#8A0CCF", "#CD0D74", "#754DEB", "#DDDDDD", "#999999", "#333333", "#000000", "#57032A", "#CA9726", "#990000", "#4B0C25","#F9BF3B" ];
	chart.sequencedAnimation = true;
	chart.outlineColor = "";
	chart.outlineAlpha = 0.8;
	chart.outlineThickness = 2;
	chart.labelRadius = 15;
	chart.depth3D = 20;
	chart.angle = 30;
	// WRITE
	chart.write("package_amount");
});